/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.fcs.chatlet;

import com.ibm.hwmca.fw.fcs.chatlet.ChatletProtocol;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;

public abstract class ChatletPacket
implements ChatletProtocol {
    protected short protocolVersion = 1;
    protected int chatletId = 0;
    protected int transactionId = 0;
    protected short requestType = 0;
    protected short requestSubType = 0;
    protected Map properties = new HashMap();

    protected static String typeToString(short type) {
        switch (type) {
            case 0: {
                return "REQ";
            }
            case 1: {
                return "RSP";
            }
            case 2: {
                return "MSG";
            }
        }
        return "unknown";
    }

    protected static String subtypeToString(short subtype) {
        switch (subtype) {
            case 0: {
                return "normal";
            }
            case 1: {
                return "iReq";
            }
            case 2: {
                return "error";
            }
            case 3: {
                return "terminate";
            }
        }
        return "unknown";
    }

    protected void writeToStream(ObjectOutputStream oos) throws IOException {
        oos.writeShort(this.protocolVersion);
        oos.writeInt(this.chatletId);
        oos.writeInt(this.transactionId);
        oos.writeShort(this.requestType);
        oos.writeShort(this.requestSubType);
        oos.writeObject(this.properties);
    }

    public synchronized Object setProperty(String key, Object value) {
        if (value instanceof String || value instanceof String[] || value instanceof byte[] || value instanceof int[] || value instanceof long[] || value instanceof boolean[] || value instanceof Integer || value instanceof Long || value instanceof Short || value instanceof Boolean || value instanceof Byte || value instanceof Character || value instanceof Double || value instanceof Float || value instanceof Integer || value instanceof Integer[] || value instanceof Long[] || value instanceof Short[] || value instanceof Boolean[] || value instanceof Byte[] || value instanceof Character[] || value instanceof Double[] || value instanceof Float[] || value instanceof Integer[] || value instanceof char[] || value instanceof double[] || value instanceof float[] || value instanceof short[]) {
            return this.properties.put(key, value);
        }
        throw new IllegalArgumentException("Inbound value not of supported type");
    }

    public synchronized Object getProperty(String key) {
        return this.properties.get(key);
    }

    void setTransactionId(int transactionId) {
        this.transactionId = transactionId;
    }

    int getTransactionId() {
        return this.transactionId;
    }

    void setChatletId(int chatletId) {
        this.chatletId = chatletId;
    }

    int getChatletId() {
        return this.chatletId;
    }

    void load(ObjectInputStream in) throws IOException {
    }

    public String toString() {
        return "ChatletPacket[" + this.transactionId + "," + this.chatletId + "," + ChatletPacket.typeToString(this.requestType) + "," + ChatletPacket.subtypeToString(this.requestSubType) + "," + Integer.toHexString(this.hashCode()) + "]";
    }
}

